within ;
model TransmissionTestBench

  Modelica.Blocks.Sources.Constant const(k=100)
    annotation (Placement(transformation(extent={{-74,34},{-54,54}})));
  Modelica.Mechanics.Rotational.Components.Damper damper(d=0.003)
    annotation (Placement(transformation(extent={{44,28},{64,48}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{54,-4},{74,16}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-40,34},{-20,54}})));
  Modelica.Blocks.Sources.TimeTable timeTable(table=[0,0; 1,1; 5,1; 6,2.3; 10,
        2.3; 11,0; 100,0])
    annotation (Placement(transformation(extent={{-90,-50},{-70,-30}})));
  Transmission transmission
    annotation (Placement(transformation(extent={{10,30},{30,50}})));
  TransCtrl transCtrl
    annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
equation
  connect(const.y, torque.tau) annotation (Line(
      points={{-53,44},{-42,44}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(damper.flange_b, fixed.flange) annotation (Line(
      points={{64,38},{64,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(torque.flange, transmission.flange_a) annotation (Line(
      points={{-20,44},{-8.7,44},{-8.7,40.6},{10.6,40.6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(transmission.flange_b, damper.flange_a) annotation (Line(
      points={{30,40},{34,40},{34,38},{44,38}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(timeTable.y, transCtrl.u) annotation (Line(
      points={{-69,-40},{-60,-40},{-60,1},{-52,1}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(transCtrl.g4, transmission.g4) annotation (Line(
      points={{-37,-3.2},{-1.5,-3.2},{-1.5,32.2},{12.4,32.2}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(transCtrl.g3, transmission.g3) annotation (Line(
      points={{-37,0.6},{-3.5,0.6},{-3.5,36.4},{12.4,36.4}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(transmission.g2, transCtrl.g2) annotation (Line(
      points={{12.4,43.2},{-6,43.2},{-6,4.6},{-37,4.6}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(transmission.g1, transCtrl.g1) annotation (Line(
      points={{20,47.6},{20,54},{-8,54},{-8,8.6},{-37,8.6}},
      color={0,0,127},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end TransmissionTestBench;
